#include <stdio.h>
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Button.H>
#include "Fl_Audio_Meter.H"

static float val;
static int cycle = 40000;
static int box_type = 0;

Fl_Audio_Meter *vmeter;
Fl_Audio_Meter *hmeter;

static void timeout(void *arg)
{
    Fl_Audio_Meter *m = (Fl_Audio_Meter *) arg;

    val += 0.01;
    if (val >= 1.0)
        val = 0.0;
    if (--cycle > 20000)
    {
        vmeter->sample(val);
        hmeter->sample(val);
    }
    else
    {
        vmeter->sample(0);
        hmeter->sample(0);
        if (cycle <= 0)
        {
            cycle = 40000;
            if (++box_type >= 4)
                box_type = 0;
            switch (box_type)
            {
            case 0:
                vmeter->box(FL_UP_BOX);
                hmeter->box(FL_UP_BOX);
                vmeter->peak_color(FL_YELLOW);
                vmeter->color(FL_BLUE);
                vmeter->color2(FL_GREEN);
                break;
            case 1:
                vmeter->box(FL_DOWN_BOX);
                hmeter->box(FL_DOWN_BOX);
                vmeter->color(FL_RED);
                vmeter->color2(FL_BLACK);
                break;
            case 2:
                vmeter->box(FL_PLASTIC_DOWN_BOX);
                hmeter->box(FL_PLASTIC_DOWN_BOX);
                vmeter->peak_color(FL_BLUE);
                vmeter->display_ticks(false);
                break;
            case 3:
                vmeter->box(FL_PLASTIC_UP_BOX);
                hmeter->box(FL_PLASTIC_UP_BOX);
                vmeter->peak_color(FL_GREEN);
                vmeter->display_ticks(true);
                break;
            }
        }
    }
    Fl::repeat_timeout(0.000125, timeout, m);
}

int main(int argc, char **argv)
{
    Fl_Double_Window *win = new Fl_Double_Window(100, 100, 300, 300, "Fl_Audio_Meter_Try");

    vmeter = new Fl_Audio_Meter(40, 40, 20, 150, "Level");
    hmeter = new Fl_Audio_Meter(80, 40, 150, 10, "Level");
    vmeter->box(FL_UP_BOX);
    hmeter->box(FL_UP_BOX);
    vmeter->type(FL_VERT_AUDIO_METER);
    hmeter->type(FL_HOR_AUDIO_METER);
    win->end();
    win->resizable(win);

    win->show();

    vmeter->current_value(0.0);
    hmeter->current_value(0.0);

    Fl::add_timeout(0.000125, timeout, vmeter);

    while (1)
        Fl::wait(50);

    Fl::remove_timeout(timeout, vmeter);

    return Fl::run();
}
