#ifndef _Fl_Audio_Meter_H_
#define _Fl_Audio_Meter_H_

//
// Include necessary headers.
//

#include "Fl/Fl_Widget.H"

// values for type(), lowest bit indicate horizontal:
#define FL_VERT_AUDIO_METER     0
#define FL_HOR_AUDIO_METER      1

//
// Progress class...
//

class FL_EXPORT Fl_Audio_Meter : public Fl_Widget
{
    float current_value_;
    float peak_value_;
    float gain_;
    float sample_rate_;
    float short_term_damping;
    float peak_damping;
    int samples_per_update;
    int sample_count;
    int display_ticks_;
    Fl_Color peak_color_;

protected:

    virtual void draw();

public:

    Fl_Audio_Meter(int x, int y, int w, int h, const char *l = 0);

    void peak_color(Fl_Color v) { peak_color_ = v; redraw(); }
    Fl_Color peak_color() const { return (peak_color_); }

    void display_ticks(int v) { display_ticks_ = v; redraw(); }
    float display_ticks() const { return (display_ticks_); }

    void sample_rate(float v);
    float sample_rate() const { return (sample_rate_); }

    void gain(float v) { gain_ = v; redraw(); }
    float gain() const { return (gain_); }

    void sample(float v);

    void current_value(float v) { current_value_ = v; redraw(); }
    float current_value() const { return (current_value_); }

    void peak_value(float v) { peak_value_ = v; redraw(); }
    float peak_value() const { return (peak_value_); }
};

#endif // !_Fl_Audio_Meter_H_
